// KLEINE FUNKTIONEN
const lambdaID = function(obj) {
	return obj;
};


// HAUPTFUNKTIONEN
var GLOB = {
	'handler': {
		'link': function(event) {
			var url = event.target.href;
			GLOB.response.link(event,url);
		},
		'loop': {
			'keys': function(self,f) {
				[[typ_suche,keys_suche],[typ_ad,keys_ad]].forEach(function(element) {
					var typ = element[0];
					var kkeys = element[1];
					kkeys.forEach(function(key) {
						f.call(self,typ,key);
					});
				});
			},
		},
		'kopieren': {
			selektieren: function(node) {
				var body = document.body;
				var range, sel;
				if(document.createRange && window.getSelection) {
					range = document.createRange();
					sel = window.getSelection();
					sel.removeAllRanges();
					range.selectNodeContents(node);
					sel.addRange(range);
				} else if(body.createTextRange) {
					range = body.createTextRange();
					range.moveToElementText(node);
					range.select();
				}
			},
			deselektieren: function() {
				if(document.selection) {
					document.selection.empty();
				} else if(window.getSelection) {
					window.getSelection().removeAllRanges();
				}
			},
			direkt: function(node) {
				this.selektieren(node);
				document.execCommand('copy');
			},
			bereitstellen: function(node,output) {
				var kopiert = false;
				var status = node.style.display;
				node.style.display = 'block';
				this.selektieren(node);
				try {
				if(document.execCommand('copy')) {
					output.runAttribute(self,'erfolg');
					kopiert = true;
				} else {
					output.runAttribute(self,'misserfolg');
				}
				} catch (err) {
				output.runAttribute(self,'fehler');
				}
				node.style.display = status;
				this.deselektieren();
				return kopiert;
			},
		},
		'beitragsynthetisieren': function(c,adset,typ,k,key,spalte,encode) {
			var beitrag = null;
			if(typ_suche.indexOf(typ)>=0) {
				var b = [];
				spalte.forEach(function(partition,i) {
					partition.forEach(function(block,j) {
						b = b.concat(block);
					});
					b.forEach(function(w,l) {
						b[l] = encode.call(this,w);
					});
				});
				beitrag = b.join(' ');
			} else if((typ_ad.indexOf(typ)>=0) && (keys_path.indexOf(key)>=0)) {
				var b = [];
				spalte.forEach(function(partition,i) {
					partition.forEach(function(block,j) {
						b = b.concat(block);
					});
				});
				beitrag = b.join('-');
			} else if((typ_ad.indexOf(typ)>=0) && (keys_head.indexOf(key)>=0 || key == key_descr)) {
				var b = [];
				var fragment = [];
				spalte.forEach(function(partition,i) {
					partition.forEach(function(block,j) {
						fragment = fragment.concat(block);
					});
				});
				beitrag = fragment.join(' ').getClauses(true).join(' ');
			}
			return beitrag;
		},
	},

	response: {
		'link': function(event,url) {
			if(event.metaKey || event.ctrlKey) {
				var win = window.open(url,'_blank');
			} else {
				location.href = url;
			}
		},
		'steuerelemente': {
			'disable': function(opt) {
				var element = document.getElementsByClassName('steuerelemente');
				for(var i=0; i<element.length; i++) {
					var btn = element[i].getElementsByTagName('input');
					for(var k=0; k<btn.length; k++) {
						btn[k].disabled = opt;
					}
				}
			},
		},
		'meldung':  function(html_id,str) {
			document.getElementById(html_id+'div#meldung#text').textContent = str;
		},
	},
};